require 'webrick'

class WebServer < WEBrick::HTTPServlet::AbstractServlet
  def do_GET(request, response)
    case request.path
    when "/"
      response.status = 200
      response['Content-Type'] = 'text/plain'
      response.body = 'Witaj, świecie'
    when "/api"
      response.status = 201
      response['Content-Type'] = 'application/json'
      response.body = '{"foo":"bar"}'
    else
      response.status = 404
      response['Content-Type'] = 'text/plain'
      response.body = 'Nie znaleziono'
    end
  end
end

# Ten kod będzie działał tylko po uruchomieniu skryptu bezpośrednio z poziomu
# CLI, ale nie w sytuacji, gdy będzie żądany z poziomu innego pliku.
if __FILE__ == $0
  # Uruchomienie serwera w komputerze lokalnym i nasłuchującego na porcie 8000.
  server = WEBrick::HTTPServer.new :Port => 8000
  server.mount '/', WebServer

  # Zakończenie działania serwera następuje po naciśnięciu klawiszy Ctrl+C.
  trap 'INT' do server.shutdown end

  # Uruchomienie serwera.
  server.start
end
